/*
;;;
;;;; t y p e . y
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 20-Jul-1997 8:11 
;;;; Last file update: 23-Jul-1999 19:55
;;;;
*/
%{
#include <string.h>
#include "stk.h"

SCM STk_value;

%}

%union {
    char* string;
    SCM STk_value;
}

%token  TOK_TRUE TOK_FALSE
%token <string> TOK_STR TOK_INT TOK_REAL

%type <STk_value> value

%start typedvalue

%%
typedvalue  : value { STk_value = $1; }
            ;

value       : TOK_INT { $$ = STk_Cstr2number($1,10); }
            | TOK_REAL { $$ = STk_Cstr2number($1,10); }
            | TOK_STR { $$ = STk_makestring($1); }
            | TOK_TRUE { $$ = STk_truth; }
            | TOK_FALSE { $$ = STk_ntruth; }
            ;
%%

#define MAXBUF 1024

int yyerror(char *mess)
{}

#include "lex.type.c"
PRIMITIVE STk_type(SCM Chaine_Scheme)
{
  char *input = CHARS(Chaine_Scheme);

  if (*input == '\0') /* nothing to parse */
    return STk_makestring("");
  
  {
    /* scan in-memory string input */
    YY_BUFFER_STATE buf_state = type_scan_string(input);

    typeparse();
    type_delete_buffer(buf_state);
    return STk_value;
  }
}

void Xxl_init_type(void) 
{
  STk_add_new_primitive("celltype", tc_subr_1, STk_type);
}
