/*
;;;
;;;; t r a d u c t e u r . l
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 20-Jul-1997 8:11 
;;;; Last file update: 23-Jul-1999 16:23
;;;;
*/
STRING          \"([^"]|\\\")*\"
FILENAME        {STRING}
CELL            [$]?[[:alpha:]]+[$]?[[:digit:]]+
CELLRANGE       {CELL}:{CELL}
IDENT           [[:alpha:]]+
NUM1            [[:digit:]]+\.?([eE][+-]?[[:digit:]]+)?
NUM2            [[:digit:]]*\.[[:digit:]]+([eE][+-]?[[:digit:]]+)?
NUMBER          {NUM1}|{NUM2}
%{
static INTERNAL_CELL MakeInternalCell(const char *);
static EXTERNAL_CELL MakeExternalCell(const char *); 
static INTERNAL_RANGE MakeInternalRange(const char *); 
static EXTERNAL_RANGE MakeExternalRange(const char *); 
static char *MakeFileName(const char **); 
%}

%%
[[:space:]]+	        /* skip spaces */

"#t"                    { return TOK_TRUE;  }
"#f"                    { return TOK_FALSE; }
"<"                     return '<';
">"                     return '>';
">="                    return TOK_SUPEG;
"<="                    return TOK_INFEG;
"!="                    return TOK_DIFF;
"="                     return TOK_EQ;

"+"                     return '+';
"-"                     return '-';
"*"                     return '*';
"/"                     return '/';
"%"                     return '%';

"&"                     return '&';
"and"                   return TOK_AND;
"or"                    return TOK_OR;

","                     return ',';
"("                     return '(';
")"                     return ')';


{CELL}	                { traducteurlval.intcell = 
                                    MakeInternalCell(traducteurtext); 
                          return TOK_INTERNAL_CELL;
                        }
{FILENAME}{CELL}	{ traducteurlval.extcell = 
                                    MakeExternalCell(traducteurtext); 
                          return TOK_EXTERNAL_CELL;
                        }
{CELLRANGE}             { traducteurlval.intrange = 
                                    MakeInternalRange(traducteurtext); 
                          return TOK_INTERNAL_RANGE;
                        }
{FILENAME}{CELLRANGE}	{ traducteurlval.extrange = 
                                    MakeExternalRange(traducteurtext); 
                          return TOK_EXTERNAL_RANGE;
                        }
{NUMBER}                { traducteurlval.string = strdup(traducteurtext); 
                          return TOK_NUM;
                        }

{IDENT}                 { traducteurlval.string = strdup(traducteurtext); 
                          return TOK_IDENT;
                        }

{STRING}                { traducteurlval.string = strdup(traducteurtext); 
                          return TOK_STRING;
                        }
.
%%
int traducteurwrap() {return 1;}

/* convert a col alpha coordinate to int */
static int coord2int(const char **s)
{
  register int n = 0;
  while (isalpha(**s))
    /* **s is a letter */
    n = n * 26 + toupper(*(*s)++) - 'A' + 1; 

  return n;
}

static char *MakeFileName(const char **s)
{
  char filename[MAXBUF];
  int i = 0;

  (*s)++;
  for (;;) {
    if (**s == '\"') break;
    filename[i++] = *(*s)++;
  }
  filename[i]='\0';
  return strdup(filename);
}

static INTERNAL_CELL MakeInternalCell(const char *cell)
{ 
  int row, col;
  INTERNAL_CELL c;

  c.tr = c.tc = RELATIVE;
  if (*cell == '$') {
     c.tc = ABSOLUTE;
     cell++;
  }
  /* parse col */
  c.col = coord2int(&cell);
  if (*cell == '$') {
     c.tr = ABSOLUTE;
     cell++;
  }
  /* parse row */
  c.row = atoi(cell);

  return c;
}

static EXTERNAL_CELL MakeExternalCell(const char *cell)
{ 
  EXTERNAL_CELL c;

  c.filename = MakeFileName(&cell);
  c.ci = MakeInternalCell(cell+1);
  return c;
}

static INTERNAL_RANGE MakeInternalRange(const char *range)
{
 INTERNAL_RANGE r;

 r.ci1 = MakeInternalCell(range);
 /* go after : */
 while (*range++ != ':');
 r.ci2 = MakeInternalCell(range);

 return r;
}

static EXTERNAL_RANGE MakeExternalRange(const char *range)
{ 
  EXTERNAL_RANGE r;

  r.filename = MakeFileName(&range);
  r.ri = MakeInternalRange(range+1);
  return r;
}
