/*
;;;
;;;; t r a d i n v . l
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 20-Jul-1997 8:11 
;;;; Last file update:  8-Jan-1999 09:57
;;;;
*/
STRING          \"([^"]|\\\")*\"
IDENT           [[:alpha:]]+
NUM1            [[:digit:]]+\.?([eE][+-]?[[:digit:]]+)
NUM2            [[:digit:]]*\.[[:digit:]]+([eE][+-]?[[:digit:]]+)?
REAL            {NUM1}|{NUM2}
%%

[[:space:]]+ 	        /* skip spaces */

"#t"                    { return TOK_TRUE; }
"#f"                    { return TOK_FALSE; }
"#("                    { return TOK_BEGIN_CELL; }
"#(:"                   { return TOK_BEGIN_RANGE; }

[[:digit:]]+            { tradinvlval.string = strdup(tradinvtext); 
                          return TOK_INT; 
                        }

{STRING}                { tradinvlval.string = strdup(tradinvtext); 
                          return TOK_STRING;  
                        }
{REAL}                  { tradinvlval.string = strdup(tradinvtext); 
                          return TOK_REAL; 
                        }

"or"                    return TOK_OR;
"and"                   return TOK_AND;

{IDENT}                 { tradinvlval.string = strdup(tradinvtext); 
                          return TOK_IDENT;
                        }

"<"                     return '<';
">"                     return '>';
">="                    return TOK_SUPEG;
"<="                    return TOK_INFEG;
"!="                    return TOK_DIFF;
"="                     return TOK_EQ;

"&"                     return '&';

"+"                     return '+';
"-"                     return '-';
"*"                     return '*';
"/"                     return '/';
"%"                     return '%';

"("                     return '(';
")"                     return ')';
"."                     return '.';

.
%%
#include <string.h>

int tradinvwrap() {return 1;}
