/*
;;;
;;;; s y l k . l
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 18-Jul-1999 00:24
;;;; Last file update: 20-Jul-1999 19:29
;;;;
*/
STRING          \"([^"]|\\\")*\"
IDENT           [[:alpha:]]+
NUM1            [[:digit:]]+\.?([eE][+-]?[[:digit:]]+)
NUM2            [[:digit:]]*\.[[:digit:]]+([eE][+-]?[[:digit:]]+)?
REAL            {NUM1}|{NUM2}

%{
static char *strtoupper(char *s);
%}
%%

[[:space:]]+ 	        /* skip spaces */

"#t"                    { return TOK_TRUE; }
"#f"                    { return TOK_FALSE; }
"#("                    { return TOK_BEGIN_CELL; }
"#(:"                   { return TOK_BEGIN_RANGE; }

[[:digit:]]+            { sylklval.string = strdup(sylktext); 
                          return TOK_INT; 
                        }

{STRING}                { sylklval.string = strdup(sylktext); 
                          return TOK_STRING;  
                        }
{REAL}                  { sylklval.string = strdup(sylktext); 
                          return TOK_REAL; 
                        }

"or"                    return TOK_OR;
"and"                   return TOK_AND;

"avg"                   { sylklval.string = "AVERAGE";
                          return TOK_IDENT;
                        }
"prod"                  { sylklval.string = "PRODUCT";
                          return TOK_IDENT;
                        }

{IDENT}                 { sylklval.string = 
                                      strdup(strtoupper(sylktext)); 
                          return TOK_IDENT;
                        }

"<"                     return '<';
">"                     return '>';
">="                    return TOK_SUPEG;
"<="                    return TOK_INFEG;
"!="                    return TOK_DIFF;
"="                     return TOK_EQ;

"&"                     return '&';

"+"                     return '+';
"-"                     return '-';
"*"                     return '*';
"/"                     return '/';
"%"                     return '%';

"("                     return '(';
")"                     return ')';
"."                     return '.';

.
%%
#include <string.h>

int sylkwrap() {return 1;}

/*  convert all letters in the string s to upper */
static char *strtoupper(char *s)
{
  char *s1 = s;
  while (*s) {
    *s=toupper(*s);
    s++;
  }
  return s1;
}
