/**
;;;
;;;; c s v . c
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 30-Oct-1998 10:00 
;;;; Last file update: 22-Jul-1999 16:46
;;;;
**/

/*
 *  This module defines the primitive "load-csv" to read and load values from
 *  a file in csv format into a xxl spreadsheet
 */

#include <stdlib.h>
#include <stk.h>

#define MAXBUF1 128 /* enough for most values */
#define MAXBUF2 256 /* enough for most expressions */

#define SEPARATOR ',' /* char used to separate values in csv */

#define STk_SETVALUE "(set-table-value! (current-table) %d %d (make <value-cell> \
:format '(0 . 0) :tag () :value (celltype \"%s\")))"

#define  GEN_SET_VALUE(buf1, buf2, ibuf, col, line) { \
                     if (ibuf != 0) { \
                        buf1[ibuf] = '\0'; \
		        sprintf(buf2,STk_SETVALUE,line,col,buf1); \
                        Tcl_DStringAppend(&STk_CurrentCellVal, buf2, -1); \
                        ibuf = 0; \
                     }}

static Tcl_DString STk_CurrentCellVal, STk_FinalRes;

PRIMITIVE STk_load_csv(SCM filename)
{
  /* filename is a valid csv file */
  FILE *input = fopen(CHARS(filename), "r");
  char buf1[MAXBUF1], buf2[MAXBUF2]; 
  int c, ibuf = 0;
  enum { INQUOTE, OUTQUOTE } state = OUTQUOTE;
  int col  = 1,
      line = 1,
      maxline = 1,
      maxcol  = 1;
  
  Tcl_DStringInit(&STk_CurrentCellVal);
  while ((c=fgetc(input)) != EOF)
    switch (c) {
       case '"'  : if (state == OUTQUOTE) state = INQUOTE;
                   else
                     /* state == INQUOTE */
		     if ((c=fgetc(input)) == '"') {
		       buf1[ibuf++] = '\\'; buf1[ibuf++] = '"';
		     }
                     else {
		       /* it was the last one */
		       state = OUTQUOTE;
		       ungetc(c,input);
		   }
                   break;
       case SEPARATOR  
                 : if (state == OUTQUOTE) {
                       /* this comma is a seperator */ 
                       GEN_SET_VALUE(buf1, buf2, ibuf, col, line); 
                       col++;
                   }
                   else /* this one is inside a value */ 
		     buf1[ibuf++] = SEPARATOR;
                   break;
       case '\n' : if (state == OUTQUOTE) { 
                   /* this is the end of line */ 
                     GEN_SET_VALUE(buf1, buf2, ibuf, col, line);
		     maxline = line; maxcol = col;
	             line++; col=1;
                   }
                   else { /* newline inside a value */ 
		     buf1[ibuf++] = '\\';
		     buf1[ibuf++] = 'n';
		   }
                   break;
       default   : buf1[ibuf++] = c;
    }
  Tcl_DStringInit(&STk_FinalRes);
  Tcl_DStringAppend(&STk_FinalRes, "(begin ", -1);  
  /* set size of the spreadsheet */
  sprintf(buf1, "(extend-sheet (current-table) %d %d)", maxline, maxcol);
  Tcl_DStringAppend(&STk_FinalRes, buf1, -1);
  Tcl_DStringAppend(&STk_FinalRes, Tcl_DStringValue(&STk_CurrentCellVal), -1);
  Tcl_DStringAppend(&STk_FinalRes, ")", -1); /* close (begin */
  return STk_eval_C_string(Tcl_DStringValue(&STk_FinalRes), NIL); 
}

void Xxl_init_csv(void) 
{
  STk_add_new_primitive("load-csv", tc_subr_1, STk_load_csv);
}
