/*
;;;
;;;; l i b x x l . c
;;;;
;;;; xxl project -- Universite de Nice Sophia Antipolis
;;;;                U.F.R. Sciences - Maitrise d'Informatique
;;;;                project supervisor  V. Granet (vg@unice.fr)
;;;;
;;;; Copyright (C) 1996-1999 U.N.S.A.
;;;; 
;;;; xxl is a free software.  Permission to use, copy, and/or distribute
;;;; this software and its documentation for any purpose and without fee is
;;;; hereby granted, provided that both the above copyright notice and this
;;;; permission notice appear in all copies and derived works. Fees for
;;;; distribution or use of this software or derived works are forbidden.
;;;; This software is provided ``as is'' without any warranty.
;;;; 
;;;;       Author    : Marie Monet
;;;;
;;;; Creation date   : 20-Jul-1997 8:11 
;;;; Last file update: 24-Jul-1999 16:57
;;;;
*/
#include <stk.h>
#include <stdlib.h>
#include <string.h>
#include "utils.h"

#if NO_STRDUP
char * strdup(const char *s)
{
  char *s1 = (char *) malloc(strlen(s) + 1);
  return s1 ? strcpy(s1, s) : NULL;
}
#endif

#define MAXBUF 512


/* to get the object value pointed */
extern char *STk_convert_for_Tcl(SCM obj, SCM *res);

static PRIMITIVE STk_addr_obj(SCM obj)
{
  SCM res; /* not used */
  return STk_address2object(STk_convert_for_Tcl(STk_eval(obj,NIL), &res)+2);
}

static char *split(char *buf, char comma, int precision)
{
#define BLOCK 3

  char res[MAXBUF];
  int i, j, k, lg = strlen(buf)-precision-1;

  if (precision) buf[lg] = comma; else lg++;
  k = 0;
  if (lg > BLOCK) {
    for (i = lg % BLOCK ; i>0; i--)
      res[k++] = *buf++;
    for (i = lg / BLOCK ; i>0 ; i--) {
      res[k++] = ' ';      
      for (j=0; j < BLOCK; j++)
	res[k++] = *buf++;
    }
  }
  while (*buf)
    res[k++] = *buf++;
  res[k] = '\0';
  return strdup(res);
}

static PRIMITIVE STk_display_currency(SCM stk_format,  
				   SCM stk_precision, SCM stk_number)
{
  char *val, buf1[MAXBUF], buf2[MAXBUF];
  int neg = 0, format =  STk_integer_value(stk_format),
      precision =  STk_integer_value(stk_precision);  
  double d;

  val = STk_number2Cstr(stk_number,10,buf1);
  if (EXACTP(stk_number)) {
    if (*val == '-') {
      neg = 1; val++;
    }
    if (precision) {
      sprintf(buf2,"%%s.%%0%dd",precision);
      sprintf(buf1,buf2,val,0); 
    }
    else sprintf(buf1, "%s", val);
  }
  else {
    d = atof(val);
    if (d<0) {
      neg = 1; d = -d;
    }
    sprintf(buf2,"%%.%df",precision);
    sprintf(buf1,buf2,d);
  }
  switch (format) {
     case EURO : sprintf(buf2, "%s%s E", neg? "-" : "", 
                      split(buf1,',',precision)); break;  /* Euro   */
     case FRANC : sprintf(buf2, "%s%s F", neg? "-" : "", 
                      split(buf1,',',precision)); break;  /* Franc  */
     case DOLLAR : sprintf(buf2, "%s%s", neg? "-$" : "$", 
         	      split(buf1,'.',precision)); break;  /* dollar  */
  }
  return STk_eval_C_string(STk_stringify(buf2,0),NIL);  
}

static PRIMITIVE STk_display_number(SCM stk_format, 
				    SCM stk_precision, SCM stk_number)
{
  char f[MAXBUF], *val, buf[MAXBUF];
  int format    =  STk_integer_value(stk_format),
      precision =  STk_integer_value(stk_precision); 

  val = STk_number2Cstr(stk_number,10,buf);
  switch (format) {
     case FIXED      :
                      if (EXACTP(stk_number)) {
			if (precision) {
			  sprintf(f,"%%s.%%0%dd",precision);
			  sprintf(buf,f,val,0);
			}
			else sprintf(buf, "%s", val);
		      }
		      else {
			sprintf(f,"%%.%df",precision);
			sprintf(buf,f,atof(val));
		      }
		      break;
     case SCIENTIFIC : /*  scientific notation uses exposant */
                      sprintf(f,"%%.%de",precision);
		      sprintf(buf,f,atof(val));
		      break;
     case FINANCIAL  :
                      if (EXACTP(stk_number)) {
			if (precision) {
			  sprintf(f,"%%s.%%0%dd",precision);
			  sprintf(buf,f,val,0);
			}
			else sprintf(buf, "%s", val);
		      }
		      else {
			sprintf(f,"%%.%df",precision);
			sprintf(buf,f,atof(val));
		      }
                      strcpy(buf,split(buf,'.',precision));
                      break;
     case PERCENT :  /* multiply by 100 */
                      if (EXACTP(stk_number)) {
			if (precision) {
			  sprintf(f,"%%s00.%%0%dd %%%%",precision);
			  sprintf(buf,f,val,0);
			}
			else sprintf(buf,"%s00 %%",val);
		      }
		      else {
			sprintf(f,"%%.%df %%%%",precision);
			sprintf(buf,f,atof(val)*100);
		      }
  }
  return STk_eval_C_string(STk_stringify(buf,0),NIL);  
}

#define Make_Elem(s,r,c)  Cons(Cons(STk_makeinteger(r),STk_makeinteger(c)), \
			     STk_eval_C_string(STk_stringify((s),0),NIL))

static PRIMITIVE STk_split_selection(SCM Chaine_Scheme)
{
  register char *s = CHARS(Chaine_Scheme);
  enum {inword, outword} state = outword;
  char buf[MAXBUF];
  int r = 0, c = 0, i = 0;
  SCM l = NIL;

  while (*s) {
    if (*s == '\n' || *s == '\t' || *s == ' ') {
      if (state == inword) {
	state = outword;
	buf[i]='\0';
	l = Cons(Make_Elem(buf,r,c++), l);
      }
      if (*s == '\n') { r++; c = 0; }
    } else {
      if (state == outword) {
	state = inword;
	i=0;
      }
      buf[i++] = *s;
    }
    s++;
  }
  if (state == inword) {
    buf[i]='\0';
    l = Cons(Make_Elem(buf,r,c), l);
  }
  return Reverse(l);
}

char *convert_col2a(int col)
{
 char buf[MAXBUF], *res;
 int i = 0, j = 0;

 /* get all letters */
 do {
   if (col % 26 == 0) {
     buf[i++] = 'Z';
     col = (col / 26) - 1;
   }
   else {
     buf[i++] = col % 26 + 'A' - 1;
     col /= 26;
   }
 } while (col != 0);

 /* construct  the result */
 res = (char *) malloc((i + 1)); 

 while (i>0) res[j++] = buf[--i];
 res[j] = '\0';

 return res;
}


void Xxl_init_utils(void) 
{
  STk_add_new_primitive("addr->obj", tc_subr_1, STk_addr_obj);
  STk_add_new_primitive("display-number", tc_subr_3, STk_display_number);
  STk_add_new_primitive("display-currency", tc_subr_3, STk_display_currency);
  STk_add_new_primitive("split-selection", tc_subr_1, STk_split_selection);
}
